// Authentication middleware
const isAuthenticated = (req, res, next) => {
    if (req.isAuthenticated()) {
        return next();
    }
    req.flash('error', 'Please log in to view this page');
    res.redirect('/login');
};

// Authorization middleware
const isAdmin = (req, res, next) => {
    if (req.isAuthenticated() && req.user.is_admin) {
        return next();
    }
    req.flash('error', 'You do not have permission to access this page');
    res.redirect('/dashboard');
};

// Middleware to set local variables for views
const setLocals = (req, res, next) => {
    res.locals.user = req.user || null;
    res.locals.success = req.flash('success');
    res.locals.error = req.flash('error');
    next();
};

module.exports = {
    isAuthenticated,
    isAdmin,
    setLocals
};
