const { sequelize } = require('../config/database');
const User = require('./user');
const Crime = require('./crime');
const Case = require('./case');

// Define relationships
User.hasMany(Case, { foreignKey: 'officer_id' });
Case.belongsTo(User, { foreignKey: 'officer_id' });

// Many-to-Many relationship between Case and Crime
const CaseCrime = sequelize.define('case_crime', {}, { timestamps: false });

Case.belongsToMany(Crime, { through: CaseCrime });
Crime.belongsToMany(Case, { through: CaseCrime });

module.exports = {
    sequelize,
    User,
    Crime,
    Case,
    CaseCrime
};
