const express = require('express');
const router = express.Router();
const { isAuthenticated, isAdmin } = require('../middleware/auth');
const adminController = require('../controllers/adminController');

// Apply admin middleware to all routes
router.use(isAuthenticated, isAdmin);

// Admin dashboard
router.get('/', (req, res) => {
    res.redirect('/admin/crimes');
});

// User management routes
router.get('/users', adminController.getUsers);
router.put('/users/update', adminController.updateUser);
router.delete('/users/:id/delete', adminController.deleteUser);

// Crime management routes
router.get('/crimes', adminController.getCrimes);
router.get('/crimes/new', adminController.showAddCrimeForm);
router.post('/crimes', adminController.addCrime);
router.get('/crimes/:id/edit', adminController.showEditCrimeForm);
router.put('/crimes/:id', adminController.updateCrime);
router.delete('/crimes/:id', adminController.deleteCrime);
router.post('/crimes/:id/toggle', adminController.toggleCrimeStatus);

module.exports = router;
