const express = require('express');
const router = express.Router();
const { isAuthenticated } = require('../middleware/auth');
const { Case } = require('../models');

// Get all cases
router.get('/', isAuthenticated, async (req, res) => {
    try {
        const cases = await Case.findAll({
            order: [['created_at', 'DESC']],
            limit: 50
        });
        
        res.render('cases/index', {
            title: 'Cases',
            cases: cases,
            user: req.user
        });
    } catch (error) {
        console.error('Error fetching cases:', error);
        req.flash('error_msg', 'Error loading cases');
        res.redirect('/dashboard');
    }
});

module.exports = router;
